% DESCRIPTION:
%       script to filter the sensor data
%
% ABOUT:
%       author      - Bradley Treeby
%       date        - 25th November 2010
%       last update - 3rd February 2011
%       
% This function is part of the k-Wave Toolbox (http://www.k-wave.org)
% Copyright (C) 2009, 2010, 2011 Bradley Treeby and Ben Cox

% This file is part of k-Wave. k-Wave is free software: you can
% redistribute it and/or modify it under the terms of the GNU Lesser
% General Public License as published by the Free Software Foundation,
% either version 3 of the License, or (at your option) any later version.
% 
% k-Wave is distributed in the hope that it will be useful, but WITHOUT ANY
% WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
% FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
% more details. 
% 
% You should have received a copy of the GNU Lesser General Public License
% along with k-Wave. If not, see <http://www.gnu.org/licenses/>.

if use_sensor && ~time_rev && isfield(sensor, 'frequency_response')

    % get the transducer properties
    centre_f = sensor.frequency_response(1);
    bandwidth = sensor.frequency_response(2);

    % get the frequency axis
    [f, as] = spectrum(sensor_data(1, :), 1/dt);

    % compute the coefficients
    coeff_c = bandwidth/100*centre_f / (2*sqrt(2*log(2)));
    coeff_b = centre_f;
    gauss = exp(-(f(1:end-1) - coeff_b).^2 / (2*coeff_c^2));
    gauss = gauss./max(gauss(:));

    % apply the filter
    sensor_data = fft(sensor_data, [], 2).*repmat([gauss, flipud(gauss)], length(sensor_data(:, 1)), 1);
    sensor_data = real(ifft(sensor_data, [], 2));
    
%     % uncomment to plot the filter
%     figure;
%     [f_sc, f_scale, f_prefix] = scaleSI(max(f(:)));
%     plot(f(1:end-1)*f_scale, gauss, 'k-');
%     xlabel(['Frequency [' f_prefix 'Hz]']);
%     ylabel('Filter Magnitude');    
    
end